# Copyright (c) Alibaba, Inc. and its affiliates.
import yaml

try:
    from yaml import CDumper as Dumper
    from yaml import CLoader as Loader
except ImportError:
    from yaml import Loader, Dumper  # type: ignore

from .base import FormatHandler  # isort:skip


class YamlHandler(FormatHandler):

    def load(self, file, **kwargs):
        kwargs.setdefault('Loader', Loader)
        return yaml.safe_load(file)

    def dump(self, obj, file, **kwargs):
        kwargs.setdefault('Dumper', Dumper)
        yaml.dump(obj, file, **kwargs)

    def dumps(self, obj, **kwargs):
        kwargs.setdefault('Dumper', Dumper)
        return yaml.dump(obj, **kwargs)
