import sys
from typing import (
    Any,
    Callable,
    Iterator,
    List,
    Optional,
    Tuple,
    TypeVar,
    Union,
    overload,
)

import numpy as np

T = TypeVar('T')

def glob_with_braces(pattern: str) -> List[str]: ...
def fnmatch_with_braces(filename: str, pattern: str) -> bool: ...
def make_seed(*args: Any) -> int: ...
def is_iterable(obj: Any) -> bool: ...

class PipelineStage:
    def invoke(self, *args: Any, **kw: Any) -> Any: ...
    def run(self, *args: Any, **kw: Any) -> Any: ...

def identity(x: T) -> T: ...
def safe_eval(s: str, expr: str = "{}") -> Any: ...
def lookup_sym(sym: str, modules: List[str]) -> Optional[Any]: ...
def repeatedly0(loader: Iterator[T], nepochs: int = sys.maxsize, nbatches: int = sys.maxsize) -> Iterator[T]: ...
def guess_batchsize(batch: Union[Tuple, List]) -> int: ...

def repeatedly(
    source: Iterator[T],
    nepochs: Optional[int] = None,
    nbatches: Optional[int] = None,
    nsamples: Optional[int] = None,
    batchsize: Callable[..., int] = guess_batchsize,
) -> Iterator[T]: ...

def pytorch_worker_info(group: Any = None) -> Tuple[int, int, int, int]: ...
def pytorch_worker_seed(group: Any = None) -> int: ...

@overload
def deprecated(func: Callable[..., Any]) -> Callable[..., Any]: ...
@overload
def deprecated(arg: Optional[str] = None) -> Callable[[Callable[..., Any]], Callable[..., Any]]: ...

class ObsoleteException(Exception): ...

def obsolete(func: Optional[Callable[..., Any]] = None, *, reason: Optional[str] = None) -> Union[Callable[..., Any], Callable[[Callable[..., Any]], Callable[..., Any]]]: ...

def compute_sample_weights(n_w_pairs: List[Tuple[float, float]]) -> np.ndarray: ...
