import sys
from typing import Any, Dict, List, Optional, Tuple, Union

import numpy as np

# Type aliases for clarity
ByteData = Union[bytes, bytearray, memoryview]
ArrayLike = np.ndarray
InfoType = Union[bool, List[str], Tuple[str, ...]]

# Constants
long_to_short: Dict[str, str]
short_to_long: Dict[str, str]
magic_str: str
magic: int
magic_bytes: bytes

def bytelen(a: Union[np.ndarray, bytearray, bytes]) -> int: ...
def bytedata(a: Union[np.ndarray, bytearray, bytes, memoryview]) -> Union[bytes, bytearray, memoryview]: ...
def check_acceptable_input_type(data: List[np.ndarray], allow64: bool) -> None: ...
def str64(s: str) -> int: ...
def unstr64(i: int) -> str: ...
def check_infos(data: List[np.ndarray], infos: List[str], required_infos: Optional[InfoType] = None) -> Union[List[np.ndarray], Tuple[List[np.ndarray], List[str]]]: ...
def encode_header(a: np.ndarray, info: str = "") -> ByteData: ...
def decode_header(h: ByteData) -> Tuple[Tuple[int, ...], np.dtype, str]: ...
def encode_list(l: List[np.ndarray], infos: Optional[List[str]] = None) -> List[ByteData]: ...
def decode_list(l: List[ByteData], infos: InfoType = False) -> Union[List[np.ndarray], Tuple[List[np.ndarray], List[str]]]: ...
def roundup(n: int, k: int = 64) -> int: ...
def encode_chunks(l: List[Union[np.ndarray, ByteData]]) -> bytearray: ...
def decode_chunks(buf: ByteData) -> List[ByteData]: ...
def encode_buffer(l: List[np.ndarray], infos: Optional[List[str]] = None) -> bytearray: ...
def decode_buffer(buf: ByteData, infos: InfoType = False) -> Union[List[np.ndarray], Tuple[List[np.ndarray], List[str]]]: ...
def write_chunk(stream: Any, buf: Union[np.ndarray, ByteData]) -> None: ...
def read_chunk(stream: Any) -> Optional[bytes]: ...
def write(stream: Any, l: List[np.ndarray], infos: Optional[List[str]] = None) -> None: ...
def read(stream: Any, n: int = sys.maxsize, infos: InfoType = False) -> Union[List[np.ndarray], Tuple[List[np.ndarray], List[str]]]: ...
def save(fname: str, *args: np.ndarray, infos: Optional[List[str]] = None, nocheck: bool = False) -> None: ...
def load(fname: str, infos: InfoType = False, nocheck: bool = False) -> Union[List[np.ndarray], Tuple[List[np.ndarray], List[str]]]: ...
